/* 
Function supplied with Fwatch v1.13
Checks if given string/(array with strings) is in the _keys array and returns bool.
Local variables _pressed and _keys must be set before calling this function.

Usage:
	_pressed = []
	_keys = []
	_isHotkey = <input> call preProcessFile "..\fwatch\data\inKeys.sqf"

Where <input> can be a string:
	"A" 			- if "A" is in the _keys
or an array with strings:
	["A"]			- if "A" is in the _keys
	["A", "B"]		- if both "A" and "B" are in the _keys
	[["A", "B"]]	- if "A" or "B" are in the _keys
	[["A","B"],"C"]	- if "A" or "B" and "C" are in the _keys
	
String is added to the _pressed array to prevent continuous activation.

For a combination only last item in the array is added to the
_pressed. For example: ["SHIFT","A"] - "A" will be added to the
array and "SHIFT" will not.
*/




private ["_item", "_return", "_last", "_i", "_j", "_max"];
_return = false;

if (_this in [_this]) then
{
	// for single string
	if (_this in _keys && !(_this in _pressed)) then
	{
		// click
		_pressed = _pressed + [_this];
		_return = true;
	};

	// release
	if (!(_this in _keys) && _this in _pressed) then
	{
		_pressed = _pressed - [_this];
	};
}


else


{
	_item =+ _this;
	
	// Sub-Arrays - alternative keys
	_i = 0;
	while "_i < count _item" do
	{
		// If a sub-array
		if (!((_item select _i) in [(_item select _i)])) then
		{
			// Remove from _pressed
			"if (!(_x in _keys)) then {_pressed=_pressed-[_x]}" forEach (_item select _i);
			
			// If one of the key is pressed
			_j = 0;
			_max = count (_item select _i);
			while "_j < _max" do
			{
				// Replace sub-array with that string for later check
				if (((_item select _i) select _j) in _keys) then 
				{
					_item set [_i, (_item select _i) select _j];
					_j = _max
				};
				_j = _j + 1;
			};
			
			// If none were pressed
			if (_j==_max) then {_item set [_i, "false"]};
		};
		_i = _i + 1;
	};
	
	

	// for an array
	_last = _item select (count _item -1);
	
	if ("_x in _keys" count _item == count _item  &&  !(_last in _pressed)) then
	{
		// click
		_pressed = _pressed + [_last];
		_return = true;
	};

	// release
	if (!(_last in _keys) && _last in _pressed) then
	{
		_pressed = _pressed - [_last];
	};
};

_return